#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Colored Sphere WavesMod01.fsh   by  derSchamane  
//https://www.shadertoy.com/view/sldBRS
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//                   = Colored Sphere Waves =         
//                by  Maximilian Knape ·∑>| 2022            
// -----------------------------------------------------------
// This work is licensed under a Creative Commons Attribution-
//        NonCommercial-ShareAlike 3.0 Unported License


#define MAX_STEPS 300
#define MAX_DIS 500.
#define MIN_DIS 20.

#define SURF_DIS .001
#define SURF_MUL 100.
#define SURF_EXP 2.

//#define iTime iTime*.5

mat2 Rot(float a) 
{
    float s = sin(a);
    float c = cos(a);
    return mat2(c, -s, s, c);
}

float Dist(vec3 p) 
{
    p.xy *= Rot(smoothstep(-.2,.2,sin(iTime/15.))*.785);
    p.xz *= Rot((smoothstep(-.8,.0,sin(iTime/12.))*2.-1.)*1.57+1.57);

    float f = 1./(300.+sin(iTime/11.)*120.-sin(iTime/9.)*80.+sin(iTime/7.)*50.);
    float dis = length(p)*f;
    
    p.xy *= Rot(p.z/MAX_DIS*(smoothstep(.2,1.,sin(iTime/13.)) - smoothstep(-.2,-1.,sin(iTime/13.)))*6.28);

    vec3 size = vec3(20.+sin(iTime/33.)*5.);
    p = mod(abs(-mod(p,4.*size)+2.*size),4.*size);    

    float d = length(p - sin(iTime*.5+dis*6.28)*size.x-size) - 
              (10.+sin(iTime/33.)*5.)*(sin(iTime*1.5+dis*6.28)*.5+.8)*
              (1.+.5*smoothstep(0.8,1.,sin(iTime/3.+dis/f/200.))); 

    return d;
}

vec3 RTM(vec3 ro, vec3 rd) 
{
    int steps;
    float sum = 0.;
	float s = 1.;
    float d = MIN_DIS;
    const float a = 1. / float(MAX_STEPS); 
    vec3 p = vec3(0.);
    
    for(int i = 0; i < MAX_STEPS; i++) 
    {    
        float sd = (SURF_DIS * (pow(d/MAX_DIS, SURF_EXP)*SURF_MUL+1.));
        if (s < sd || d > MAX_DIS) break;
        
        steps = i;
        p = ro + rd*d;
        s = Dist(p);
        s = max(abs(s), 2.*sd);
        d += s * 0.5;
        sum += a;
    }
    
    return vec3(smoothstep(0., 1., sum * (1.-exp(-d*d))), tanh(s/150.), float(steps) / float(MAX_STEPS));
}

vec3 R(vec2 uv, vec3 p, vec3 l, float z)
{
    vec3 f = normalize(l-p),
        r = normalize(cross(vec3(0.,1.,0.), f)),
        u = cross(f,r),
        c = p+f*z,
        i = c + uv.x*r + uv.y*u,
        d = normalize(i-p);
    return d;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord-.5*iResolution.xy) / iResolution.y;
    vec3 ro = vec3( 0., 0., -80.);
    vec3 rd = R(uv, ro, vec3(0.), .3 + .8*smoothstep(.5,1.,sin(iTime/12.)));
    vec3 r = RTM(ro, rd);
    
    vec3 col = vec3(r.y*r.z+r.y+r.x*.1, r.z-r.x*.4+r.y*.4, r.x-r.y);
    col *= smoothstep(2.,-2./5., dot(uv,uv)); 
    vec3 colS = smoothstep(vec3(0.), vec3(1.), vec3(col));
    
    fragColor = vec4(colS, 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

